VERSION 5.00
Begin VB.Form DC_SurchargeDetail 
   Caption         =   "#Surcharge detail"
   ClientHeight    =   2670
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   4725
   LinkTopic       =   "Form1"
   ScaleHeight     =   2670
   ScaleWidth      =   4725
   StartUpPosition =   3  'Windows Default
   Begin VB.ComboBox cbo_language 
      Height          =   315
      Left            =   2970
      Style           =   2  'Dropdown List
      TabIndex        =   10
      Top             =   90
      Width           =   615
   End
   Begin VB.CheckBox chk_DCS_IsUsed 
      Height          =   315
      Left            =   1575
      TabIndex        =   9
      Tag             =   "DCS_IsUsed"
      Top             =   1725
      Width           =   285
   End
   Begin VB.CommandButton CancelButton 
      Cancel          =   -1  'True
      Caption         =   "Cancel"
      Height          =   375
      Left            =   1965
      TabIndex        =   7
      Top             =   2205
      Width           =   1215
   End
   Begin VB.CommandButton OKButton 
      Caption         =   "OK"
      Default         =   -1  'True
      Height          =   375
      Left            =   3390
      TabIndex        =   6
      Top             =   2205
      Width           =   1215
   End
   Begin VB.TextBox txt_DCS_Desc 
      Height          =   330
      Left            =   1575
      Locked          =   -1  'True
      MaxLength       =   50
      TabIndex        =   4
      Tag             =   "DCS_Desc"
      Top             =   555
      Width           =   3075
   End
   Begin VB.TextBox txt_DCS_Code 
      Height          =   330
      Left            =   1575
      Locked          =   -1  'True
      MaxLength       =   4
      TabIndex        =   3
      Tag             =   "DCS_Code"
      Top             =   90
      Width           =   1125
   End
   Begin VB.TextBox txt_DCS_Info 
      Height          =   660
      Left            =   1575
      MaxLength       =   250
      MultiLine       =   -1  'True
      TabIndex        =   0
      Tag             =   "DCS_Info"
      Top             =   1005
      Width           =   3045
   End
   Begin VB.Label lbl_labels 
      Caption         =   "#Is ussed"
      Height          =   300
      Index           =   6
      Left            =   75
      TabIndex        =   8
      Tag             =   "lbl_DCS_LinkedTrans"
      Top             =   1800
      Width           =   1410
   End
   Begin VB.Label lbl_labels 
      Caption         =   "#Surcharge"
      Height          =   300
      Index           =   3
      Left            =   75
      TabIndex        =   5
      Tag             =   "lbl_DCS_Desc"
      Top             =   585
      Width           =   1365
   End
   Begin VB.Label lbl_labels 
      Caption         =   "#ID"
      Height          =   300
      Index           =   2
      Left            =   75
      TabIndex        =   2
      Tag             =   "lbl_DCS_Price"
      Top             =   120
      Width           =   1365
   End
   Begin VB.Label lbl_labels 
      Caption         =   "#Info"
      Height          =   300
      Index           =   1
      Left            =   75
      TabIndex        =   1
      Tag             =   "lbl_DCS_Info"
      Top             =   1035
      Width           =   1365
   End
End
Attribute VB_Name = "DC_SurchargeDetail"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Declare Function LockWindowUpdate Lib "user32" (ByVal hwnd As Long) As Long

Private Const SEP = ""
Private Const SEP1 As String = ""
Private Const SEP2 As String = ""
Private Const SCREEN_NAME As String = "DC_Surcharge"

Private Type tChargesDetail
    DCS_Code As String
    DCS_Desc As String
    DCS_Info As String
    Language_Code As String
    iConcurrency As Long
    Z_Creation As Date
    Z_Creator As String
    Z_Last_Upd As Date
    Z_Last_Upd_User As String
    Drop_Flag As String
    Drop_Date As Date
    action As String
End Type
Dim moa_DC_Surcharges() As tChargesDetail

Private mb_Initialized As Boolean

Public Result As Boolean
Public DCS_Desc As String
Private DCS_Info As String

Private DCS_LinkedTrans As Long

Private ml_lastLangSelected As Long

Private ml_U_Code As Long
Private ms_LoginName As String
Private ms_Language_Code As String

Private mo_Db As ARMSYSCOMLib.ArmDb
Private ms_reconnectServer As String
Private ms_reconnectDB As String
Private ms_reconnectUser As String
Private ms_reconnectPassword As String
Private ms_reconnectApp As String




Private Sub LockScreen(ByVal ab_lock As Boolean)

    Dim ll_errNumber As Long, ls_ErrSrc As String, ls_ErrDesc As String
    ll_errNumber = Err.Number
    ls_ErrSrc = Err.Source
    ls_ErrDesc = Err.Description

On Error GoTo errhandler
    Static ll_Count As Long
    Static ll_Mousepointer As Long
    Static lb_Locked As Boolean
      
      
    ll_Count = ll_Count + IIf(ab_lock, 1, -1)
    Debug.Assert (ll_Count >= 0)
    
    ' First lock
    If Not lb_Locked And ab_lock Then
        ll_Mousepointer = Screen.MousePointer
        Screen.MousePointer = vbHourglass
        LockWindowUpdate Me.hwnd
        lb_Locked = True
    End If
    
    ' Unlock
    If ll_Count = 0 Then
        DoEvents ' Flush events
        LockWindowUpdate 0
        Me.Refresh ' Repaint immediately
        Screen.MousePointer = ll_Mousepointer
        lb_Locked = False
    End If
    
    Err.Number = ll_errNumber
    Err.Source = ls_ErrSrc
    Err.Description = ls_ErrDesc
    
    Exit Sub
    
errhandler:
'    Call errorHandler("LockScreen")
End Sub

Public Sub SetReconnectParams(ByVal as_Server As String, ByVal as_Db As String, ByVal as_User As String, ByVal as_Password As String, ByVal as_App As String)
On Error GoTo errhandler
    ms_reconnectServer = as_Server
    ms_reconnectDB = as_Db
    ms_reconnectUser = as_User
    ms_reconnectPassword = as_Password
    ms_reconnectApp = as_App
    Exit Sub
errhandler:
    Call ErrorMessage("SetReconnectParams")
End Sub

Public Property Get Initialized() As Boolean
    Initialized = mb_Initialized
End Property

Property Let Language_Code(AString As String)
On Error GoTo errhandler

  ms_Language_Code = AString
  Exit Property
errhandler:
  Call ErrorMessage("Language_Code.Let")
End Property

Property Let U_Code(ByVal al_U_Code As Long)
On Error GoTo errhandler

  ml_U_Code = al_U_Code
  Exit Property
errhandler:
  Call ErrorMessage("U_Code.Let")
End Property

Public Property Let LoginName(ByVal as_loginName As String)
On Error GoTo errhandler
    
    ms_LoginName = as_loginName
    Exit Property
errhandler:
    Call ErrorMessage(Me.Name & ".LoginName(Let)")
End Property

Public Property Set ArmDb(ByRef lo_Db As Object)
On Error GoTo errhandler
  
  Set mo_Db = lo_Db
  Exit Property
errhandler:
  Call ErrorHandler("ArmDb.Set")
End Property

Public Sub Load_A_COM()
On Error GoTo errhandler

    If mb_Initialized Then Exit Sub
    
    mb_Initialized = True
    
    Result = False
    
    Dim lo_Control As Object
    
    For Each lo_Control In Controls
        Select Case UCase(TypeName(lo_Control))
        Case "ARMCOMBOBOX"
          Set lo_Control.ArmDb = mo_Db
          Call lo_Control.Load_A_COM
        Case "ARMPICKER"
          Set lo_Control.ArmDb = mo_Db
          Call lo_Control.Load_A_COM
        Case "TOOLBARCONTROL"
          lo_Control.Language = ms_Language_Code
'          Set lo_Control.ArmDb = mo_Db
          Call lo_Control.Load_A_COM
        Case "ARMGRID"
          Set lo_Control.ArmDb = mo_Db
          Call lo_Control.Load_A_COM
        Case "ARMTREEVIEW"
          Set lo_Control.ArmDb = mo_Db
          lo_Control.Language = ms_Language_Code
          Call lo_Control.Load_A_COM
        Case "ARMCHECKVIEW"
          Set lo_Control.ArmDb = mo_Db
          Call lo_Control.Load_A_COM
        Case "A_CALOCX"
          lo_Control.Language = ms_Language_Code
          Call lo_Control.reinit_cal
        Case "TOOLBR"
          Set lo_Control.ArmDb = mo_Db
          Call lo_Control.Load_A_COM
        End Select
    Next
    
    ReDim moa_DC_Surcharges(-1 To -1) As tChargesDetail

    ml_lastLangSelected = -1
    Call LoadLabels(Me.Controls, SCREEN_NAME, ms_Language_Code)
    Call ChangeCharset(Me.Controls, GetCodePageFromLanguage(mo_Db, ms_Language_Code))

    Exit Sub
    
errhandler:
    Call ErrorHandler("Load_A_COM")
End Sub

Public Property Let Title(ByVal as_caption As String)
    Me.Caption = as_caption
End Property

Private Sub CancelButton_Click()
On Error GoTo errhandler

    Result = False
    Call txt_DCS_Code.SetFocus
    Me.Hide

    Exit Sub
errhandler:
    Call ErrorMessage("CancelButton_Click()")
End Sub

Private Sub cbo_language_Click()
On Error GoTo errhandler
    
    If ml_lastLangSelected <> -1 Then
        Call Item_SaveLocal(ml_lastLangSelected)
    End If
    
    If cbo_language.ListIndex <> -1 Then
        Call Item_LoadLocal(cbo_language.ItemData(cbo_language.ListIndex))
    End If
    
    Exit Sub
errhandler:
    Call ErrorMessage("cbo_language_Click()")
End Sub

Private Sub OKButton_Click()
On Error GoTo errhandler

    If Not txt_DCS_Desc.Locked Then
        If Item_Check Then
            Call Item_SaveLocal(ml_lastLangSelected)
            Call DCS_Desc_update(DCS_Desc, DCS_Info)
            Call Item_Save
            
            Call txt_DCS_Desc.SetFocus
            
            Result = True
            Me.Hide
        End If
    Else
        ' if the result is without the check
        If Result Then
            Call Item_Save
        End If
        Call txt_DCS_Code.SetFocus
        Me.Hide
    End If
    Exit Sub
errhandler:
    Call ErrorMessage("OKButton_Click()")
End Sub

Private Sub Item_Save()
On Error GoTo errhandler
    
Const C_REQ_I As String = "EXEC DC_Surcharge_ins $DCS_CODE$, $CARRIER_CODE$, $DCS_DESC$, $DCS_INFO$, $LANG$, $USER$"
Const C_REQ_U As String = "EXEC DC_Surcharge_upd $DCS_CODE$, $DCS_DESC$, $DCS_INFO$, $LANG$, '', $USER$, $ICONC$"
Const C_REQ_D As String = "EXEC DC_Surcharge_del $DCS_CODE$, $LANG$"

    Dim ls_req As String

    Dim ll_i As Long
    For ll_i = LBound(moa_DC_Surcharges) To UBound(moa_DC_Surcharges)
        
        ls_req = ""
        Select Case moa_DC_Surcharges(ll_i).action
            Case "A"
                ls_req = C_REQ_I
            Case "U"
                ls_req = C_REQ_U
            Case "D"
                ls_req = C_REQ_D
        End Select
        
        If ls_req <> "" Then
            ls_req = Replace(ls_req, "$DCS_CODE$", SqlStr(moa_DC_Surcharges(ll_i).DCS_Code, 4), , , vbTextCompare)
            ls_req = Replace(ls_req, "$DCS_DESC$", SqlStr(moa_DC_Surcharges(ll_i).DCS_Desc, 50), , , vbTextCompare)
            ls_req = Replace(ls_req, "$DCS_INFO$", SqlStr(moa_DC_Surcharges(ll_i).DCS_Info, 250), , , vbTextCompare)
            ls_req = Replace(ls_req, "$LANG$", SqlStr(moa_DC_Surcharges(ll_i).Language_Code, 1), , , vbTextCompare)
            ls_req = Replace(ls_req, "$ICONC$", SQLNum(moa_DC_Surcharges(ll_i).iConcurrency), , , vbTextCompare)
            ls_req = Replace(ls_req, "$CARRIER_CODE$", "''", , , vbTextCompare)
            ls_req = Replace(ls_req, "$USER$", SqlStr(ms_LoginName, 15), , , vbTextCompare)
            
            Call ExecuteSQLSafe(mo_Db, ls_req)
        End If
        
    Next
        
    Exit Sub
errhandler:
    Call ErrorHandler("Item_SaveLocal()")
End Sub

Private Sub Item_SaveLocal(ByVal al_Index As Long)
On Error GoTo errhandler
    
    Debug.Assert (al_Index <> -1)
    
    If moa_DC_Surcharges(al_Index).DCS_Desc <> Trim(txt_DCS_Desc.Text) Or _
        moa_DC_Surcharges(al_Index).DCS_Info <> Trim(txt_DCS_Info.Text) _
    Then
        If moa_DC_Surcharges(al_Index).action = "" Then
            moa_DC_Surcharges(al_Index).action = "U"
        End If
    End If
    
    moa_DC_Surcharges(al_Index).DCS_Desc = Trim(txt_DCS_Desc.Text)
    moa_DC_Surcharges(al_Index).DCS_Info = Trim(txt_DCS_Info.Text)
    
    If gut_LangLogin.Code = moa_DC_Surcharges(al_Index).Language_Code Then
        DCS_Desc = moa_DC_Surcharges(al_Index).DCS_Desc
        DCS_Info = moa_DC_Surcharges(al_Index).DCS_Info
    End If
    DCS_Code = Trim(txt_DCS_Code.Text)
    
    Exit Sub
errhandler:
    Call ErrorHandler("Item_SaveLocal()")
End Sub

Private Property Let DCS_Code(ByVal as_DCS_Code As String)
On Error GoTo errhandler

    Dim ll_i As Long
    For ll_i = LBound(moa_DC_Surcharges) To UBound(moa_DC_Surcharges)
        moa_DC_Surcharges(ll_i).DCS_Code = as_DCS_Code
    Next
    
    Exit Property
errhandler:
    Call ErrorMessage(Me.Name & ".DCS_Code(Let)")
End Property

Public Property Get DCS_Code() As String
On Error GoTo errhandler
    
    DCS_Code = moa_DC_Surcharges(LBound(moa_DC_Surcharges)).DCS_Code
    
    Exit Property
errhandler:
    Call ErrorMessage(Me.Name & ".DCS_Code(Get)")
End Property

Private Sub DCS_Desc_update(ByVal as_DCS_Desc_Lang As String, ByVal as_DCS_Info_Lang As String)
On Error GoTo errhandler

    Dim ll_i As Long
    For ll_i = LBound(moa_DC_Surcharges) To UBound(moa_DC_Surcharges)
        If moa_DC_Surcharges(ll_i).DCS_Desc = "" Then
            moa_DC_Surcharges(ll_i).DCS_Desc = "#" & as_DCS_Desc_Lang
        End If
        If moa_DC_Surcharges(ll_i).DCS_Info = "" Then
            moa_DC_Surcharges(ll_i).DCS_Info = "#" & as_DCS_Info_Lang
        End If
    Next

    Exit Sub
errhandler:
    Call ErrorMessage(Me.Name & ".DCS_Desc_update")
End Sub

Private Function Item_Check() As Boolean
On Error GoTo errhandler
Const C_REQ As String = "SELECT DISTINCT CARRIER_Code FROM DC_Surcharge WHERE DCS_Code = $DCS_Code$"

    Item_Check = False

    Dim ll_Cursor As Long
    
    If txt_DCS_Code.Text = "" Then
        MsgBox ("Invalid value in Surcharge code.")
        txt_DCS_Code.SelStart = 0
        txt_DCS_Code.SelLength = Len(txt_DCS_Code.Text)
        Call txt_DCS_Code.SetFocus
        Exit Function
    End If
    
    If txt_DCS_Desc.Text = "" Then
        MsgBox ("Invalid value in Surcharge.")
        txt_DCS_Desc.SelStart = 0
        txt_DCS_Desc.SelLength = Len(txt_DCS_Desc.Text)
        Call txt_DCS_Desc.SetFocus
        Exit Function
    End If
    
    If Not txt_DCS_Code.Locked Then
        ' if we allow user to update the code -> only in add mode
        ll_Cursor = OpenSQLSafe(mo_Db, Replace(C_REQ, "$DCS_Code$", SqlStr(txt_DCS_Code.Text, 4), , , vbTextCompare))
        
        Dim ll_Count As Long
        Dim ls_someCarrier  As String
        
        ll_Count = mo_Db.RowCount(ll_Cursor)
        ls_someCarrier = mo_Db.GetFields(ll_Cursor, "CARRIER_Code")
        
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
        
        If ll_Count > 0 Then
            MsgBox ("Surcharge code already exists in database. (" & ls_someCarrier & ")")
            txt_DCS_Code.SelStart = 0
            txt_DCS_Code.SelLength = Len(txt_DCS_Code.Text)
            Call txt_DCS_Code.SetFocus
            Exit Function
        End If
    End If
    
    Item_Check = True
    Exit Function
errhandler:
    If ll_Cursor > 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    End If
End Function

Private Sub Item_LoadLocal(ByVal al_Index As Long)
On Error GoTo errhandler

    txt_DCS_Desc.Text = moa_DC_Surcharges(al_Index).DCS_Desc
    txt_DCS_Info.Text = moa_DC_Surcharges(al_Index).DCS_Info
    
    If gut_LangLogin.Code = moa_DC_Surcharges(al_Index).Language_Code Then
        DCS_Desc = moa_DC_Surcharges(al_Index).DCS_Desc
        DCS_Info = moa_DC_Surcharges(al_Index).DCS_Info
    End If
    
    ml_lastLangSelected = al_Index

    Exit Sub
errhandler:
    Call ErrorHandler("Item_LoadLocal()")
End Sub


Private Sub Item_Load(ByVal as_DCS_Code As String)
On Error GoTo errhandler

Const C_REQ As String = "EXEC DC_Surcharge_sel $DCS_Code$"
Const C_REQ_I As String = "EXEC Language_cbo"
    
    Dim ls_req As String
    Dim ll_Cursor As Long
    
    Dim ll_IndxToShow As Long
    ll_IndxToShow = -1
    
    Call cbo_language.Clear
    
    txt_DCS_Code.Text = as_DCS_Code
    
    If as_DCS_Code <> "" Then
    
        ls_req = Replace(C_REQ, "$DCS_Code$", SqlStr(as_DCS_Code, 4), , , vbTextCompare)
        ll_Cursor = OpenSQLSafe(mo_Db, ls_req)
        
        Debug.Assert (mo_Db.RowCount(ll_Cursor) > 0)
        
        ReDim moa_DC_Surcharges(mo_Db.RowCount(ll_Cursor) - 1) As tChargesDetail
        While Not mo_Db.EOF(ll_Cursor)
            moa_DC_Surcharges(mo_Db.Position(ll_Cursor)).DCS_Code = as_DCS_Code
            moa_DC_Surcharges(mo_Db.Position(ll_Cursor)).DCS_Desc = mo_Db.GetFields(ll_Cursor, "DCS_Desc")
            moa_DC_Surcharges(mo_Db.Position(ll_Cursor)).DCS_Info = mo_Db.GetFields(ll_Cursor, "DCS_Info")
            moa_DC_Surcharges(mo_Db.Position(ll_Cursor)).Language_Code = mo_Db.GetFields(ll_Cursor, "Language_Code")
            
            moa_DC_Surcharges(mo_Db.Position(ll_Cursor)).iConcurrency = mo_Db.GetFields(ll_Cursor, "iConcurrency")
            moa_DC_Surcharges(mo_Db.Position(ll_Cursor)).Z_Creation = mo_Db.GetFields(ll_Cursor, "Z_Creation")
            moa_DC_Surcharges(mo_Db.Position(ll_Cursor)).Z_Creator = mo_Db.GetFields(ll_Cursor, "Z_Creator")
            moa_DC_Surcharges(mo_Db.Position(ll_Cursor)).Z_Last_Upd = mo_Db.GetFields(ll_Cursor, "Z_Last_upd")
            moa_DC_Surcharges(mo_Db.Position(ll_Cursor)).Z_Last_Upd_User = mo_Db.GetFields(ll_Cursor, "Z_Last_upd_user")
            moa_DC_Surcharges(mo_Db.Position(ll_Cursor)).Drop_Flag = mo_Db.GetFields(ll_Cursor, "Drop_Flag")
            moa_DC_Surcharges(mo_Db.Position(ll_Cursor)).Drop_Date = mo_Db.GetFields(ll_Cursor, "Drop_Date")
            
            moa_DC_Surcharges(mo_Db.Position(ll_Cursor)).action = ""
            
            Call cbo_language.AddItem(moa_DC_Surcharges(mo_Db.Position(ll_Cursor)).Language_Code)
            cbo_language.ItemData(cbo_language.ListCount - 1) = mo_Db.Position(ll_Cursor)
            
            If gut_LangLogin.Code = moa_DC_Surcharges(mo_Db.Position(ll_Cursor)).Language_Code Then
                ll_IndxToShow = mo_Db.Position(ll_Cursor)
            End If
            
            Call mo_Db.Next(ll_Cursor)
        Wend
    
    Else
    
        ll_Cursor = OpenSQLSafe(mo_Db, C_REQ_I)
        
        Debug.Assert (mo_Db.RowCount(ll_Cursor) > 0)
    
        ReDim moa_DC_Surcharges(mo_Db.RowCount(ll_Cursor) - 1) As tChargesDetail
        While Not mo_Db.EOF(ll_Cursor)
            moa_DC_Surcharges(mo_Db.Position(ll_Cursor)).DCS_Code = as_DCS_Code
            moa_DC_Surcharges(mo_Db.Position(ll_Cursor)).DCS_Desc = ""
            moa_DC_Surcharges(mo_Db.Position(ll_Cursor)).DCS_Info = ""
            moa_DC_Surcharges(mo_Db.Position(ll_Cursor)).Language_Code = mo_Db.GetFields(ll_Cursor, "Language_Code")
            
            moa_DC_Surcharges(mo_Db.Position(ll_Cursor)).iConcurrency = 1
            moa_DC_Surcharges(mo_Db.Position(ll_Cursor)).Z_Creation = Now()
            moa_DC_Surcharges(mo_Db.Position(ll_Cursor)).Z_Creator = ms_LoginName
            moa_DC_Surcharges(mo_Db.Position(ll_Cursor)).Z_Last_Upd = Now()
            moa_DC_Surcharges(mo_Db.Position(ll_Cursor)).Z_Last_Upd_User = ms_LoginName
            moa_DC_Surcharges(mo_Db.Position(ll_Cursor)).Drop_Flag = ""
            moa_DC_Surcharges(mo_Db.Position(ll_Cursor)).Drop_Date = 0
            
            moa_DC_Surcharges(mo_Db.Position(ll_Cursor)).action = "A"
            
            Call cbo_language.AddItem(moa_DC_Surcharges(mo_Db.Position(ll_Cursor)).Language_Code)
            cbo_language.ItemData(cbo_language.ListCount - 1) = mo_Db.Position(ll_Cursor)
            
            If gut_LangLogin.Code = moa_DC_Surcharges(mo_Db.Position(ll_Cursor)).Language_Code Then
                ll_IndxToShow = mo_Db.Position(ll_Cursor)
            End If
            
            Call mo_Db.Next(ll_Cursor)
        Wend
        
        DCS_LinkedTrans = 0
    
    End If
    
    Debug.Assert (ll_IndxToShow <> -1)
    
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    
    If ll_IndxToShow <> -1 Then
    
        cbo_language.ListIndex = ll_IndxToShow
        
        Call Item_LoadLocal(ll_IndxToShow)
    End If
    
    chk_DCS_IsUsed.Value = IIf(DCS_LinkedTrans = 0, vbUnchecked, IIf(DCS_LinkedTrans = -1, vbGrayed, vbChecked))
    
    Exit Sub
errhandler:
    If ll_Cursor <> 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    End If
    Call ErrorHandler("Item_Load()")
End Sub

Private Sub Item_Clear()
On Error GoTo errhandler
    
    txt_DCS_Code.Text = ""
    txt_DCS_Desc.Text = ""
    txt_DCS_Info = ""
    
    DCS_Code = ""
    DCS_Desc = ""
    DCS_Info = ""
    
    ml_lastLangSelected = -1
    Exit Sub
errhandler:
    Call ErrorHandler("Item_Clear()")
End Sub

Private Sub Item_InitUpdate(ByVal as_DCS_Code As String)
On Error GoTo errhandler
    Call Item_Clear
    
    Call Item_Load(as_DCS_Code)
    
    ' updateUI
    Call EnableControl(txt_DCS_Code, False)
    Call EnableControl(txt_DCS_Desc, True)
    Call EnableControl(chk_DCS_IsUsed, False)
    Call EnableControl(txt_DCS_Info, True)
    
    Exit Sub
errhandler:
    Call ErrorMessage("Item_InitUpdate")
End Sub

Private Sub Item_InitDelete(ByVal as_DCS_Code As String)
On Error GoTo errhandler
    Call Item_Clear
    
    Call Item_Load(as_DCS_Code)
    
    Dim ll_i As Long
    For ll_i = LBound(moa_DC_Surcharges) To UBound(moa_DC_Surcharges)
        moa_DC_Surcharges(ll_i).action = "D"
    Next
    
    ' updateUI
    Call EnableControl(txt_DCS_Code, False)
    Call EnableControl(txt_DCS_Desc, False)
    Call EnableControl(chk_DCS_IsUsed, False)
    Call EnableControl(txt_DCS_Info, False)
    
    Exit Sub
errhandler:
    Call ErrorMessage("Item_InitDelete")
End Sub

Private Sub Item_InitView(ByVal as_DCS_Code As String)
On Error GoTo errhandler
    Call Item_Clear
    
    Call Item_Load(as_DCS_Code)
    
    ' updateUI
    Call EnableControl(txt_DCS_Code, False)
    Call EnableControl(txt_DCS_Desc, False)
    Call EnableControl(chk_DCS_IsUsed, False)
    Call EnableControl(txt_DCS_Info, False)
    
    Exit Sub
errhandler:
    Call ErrorMessage("Item_InitView")
End Sub

Private Sub Item_InitAdd()
On Error GoTo errhandler
    Call Item_Clear
    
    Call Item_Load("")
    
    ' updateUI
    Call EnableControl(txt_DCS_Code, True)
    Call EnableControl(txt_DCS_Desc, True)
    Call EnableControl(chk_DCS_IsUsed, False)
    Call EnableControl(txt_DCS_Info, True)
    
    Exit Sub
errhandler:
    Call ErrorMessage("Item_InitUpdate")
End Sub

' display standard error message
Private Sub ErrorMessage(ByVal as_Fct As String)
    Dim ls_ErrSource As String
    Dim ls_errDescription As String
    Dim ls_Message As String
    
    ls_ErrSource = as_Fct & SEP1 & Err.Source
    ls_errDescription = Err.Description
    ls_Message = SCREEN_NAME & " exception. Nr:" & Err.Number & ",Desc: " & ls_errDescription & ",Src:" & ls_ErrSource & "@"
'    Call mo_Tools.LogMessage(mo_Db, ml_U_Code, SCREEN_NAME, ls_Message, "E")
    Call MsgBox("Error occured, please contact IT. Application will now shutdown." & vbCrLf & ls_ErrSource & vbCrLf & "Description: " & ls_errDescription, vbCritical, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision)
    End
End Sub

' Standard error handler
Private Sub ErrorHandler(ByVal as_Fct As String)
    Err.Raise Err.Number, Me.Name & "::" & as_Fct & SEP1 & Err.Source, Err.Description
End Sub

Private Function GetDbError(ByVal lo_Db As ARMSYSCOMLib.ArmDb) As String
On Error GoTo errhandler
    If IsArray(lo_Db.SQLErrorMessages) Then
        Debug.Assert (IsArray(lo_Db.SQLErrorCodes))
        ' Display errors msgBox
        GetDbError = Join(lo_Db.SQLErrorCodes, ",") & vbCrLf & Join(lo_Db.SQLErrorMessages, vbCrLf)
    Else
        ' ExecuteSQL failed but no error message?
        GetDbError = "Unknown error"
    End If
    Exit Function
errhandler:
    Call ErrorHandler(Me.Name & ".GetDbError()")
End Function

' Load the labels of a containers
Private Sub LoadLabels(ByRef aControls As Variant, ByVal as_ScreenName As String, ByVal as_Language As String)

On Error GoTo errhandler

    Dim lIdx As Long, lCount As Long
    Dim lControl As Control
    
    Dim ll_ScreenLabels As Long

    ll_ScreenLabels = OpenSQLSafe(mo_Db, "exec Screen_Csts '" & as_ScreenName & "','" & as_Language & "'")
    Debug.Assert (ll_ScreenLabels <> 0)
    
    lCount = aControls.Count - 1
    
    For lIdx = 0 To lCount
        Set lControl = aControls.Item(lIdx)
            Select Case UCase(TypeName(lControl))
                Case "LABEL", "FRAME", "COMMANDBUTTON", "OPTIONBUTTON", "MENU", "CHECKBOX"
                    If lControl.Tag <> "" Then
                        If mo_Db.Find(ll_ScreenLabels, "FIELD_NAME", lControl.Tag, , 1) >= 0 Then
                            lControl.Caption = mo_Db.GetFields(ll_ScreenLabels, "LOCAL_TEXT")
                        End If
                        ' once translation is done and control is not in array CLEAR tag
                        If Not TypeOf lControl Is Frame And Not TypeOf lControl Is Label Then
                            lControl.Tag = ""
                        End If
                    End If
                Case "ARMGRID"
                    If mo_Db.Find(ll_ScreenLabels, "FIELD_NAME", lControl.Tag, , 1) >= 0 Then
                      Call lControl.LoadConstants(ptStatic, mo_Db.GetFields(ll_ScreenLabels, "LOCAL_TEXT"), ctColumns)
                        End If
                    If mo_Db.Find(ll_ScreenLabels, "FIELD_NAME", lControl.Tag & "_Title", , 1) >= 0 Then
                      lControl.Title = mo_Db.GetFields(ll_ScreenLabels, "LOCAL_TEXT")
                    End If
                Case "TABSTRIP"
                    If mo_Db.Find(ll_ScreenLabels, "FIELD_NAME", lControl.Tag, , 1) >= 0 Then
                        Dim lsa_TextArr() As String
                        Dim ll_Index As Long
                        
                        lsa_TextArr = Split(mo_Db.GetFields(ll_ScreenLabels, "LOCAL_TEXT"), SEP)
                        
                        For ll_Index = LBound(lsa_TextArr, 1) To UBound(lsa_TextArr, 1)
                            lControl.Tabs(ll_Index + 1).Caption = lsa_TextArr(ll_Index)
                        Next
                    End If
                    ' once translation is done and control is not in array CLEAR tag
                    lControl.Tag = ""
                Case "MSFLEXGRID", "TOOLBARCONTROL", "TEXTBOX", "ARMCHECKVIEW", "ARMCOMBOBOX", "A_CALOCX", "OPTIONBUTTON", "ARMTREEVIEW", "LISTBOX", "PICTUREBOX", "TOOLBR", "SPINBUTTON"
                    ' Do nothing !
                Case Else
                    'debug.print "LoadLabels " & UCase(TypeName(lControl))
            End Select
        Set lControl = Nothing
    Next
    
    Exit Sub

errhandler:
    Call ErrorHandler(Me.Name & ".LoadLabels")
End Sub

Private Sub ChangeCharset(ByRef ao_Container As Object, Optional ByVal aCodePage As Long)
On Error GoTo errhandler
   
    Dim lc_Control As Control
    Dim ll_Charset As Long
    
    On Error Resume Next
    ll_Charset = GetCharSetFromCodePage(aCodePage)
    
    For Each lc_Control In ao_Container
        Select Case UCase(TypeName(lc_Control))
        Case "TABSTRIP", "TEXTBOX", "LABEL", "FRAME", "COMMANDBUTTON", _
              "LISTVIEW", "CHECKBOX", "OPTIONBUTTON", _
              "ARMCHECKVIEW", "ARMTREEVIEW", "ARMGRID", "ARMCOMBOBOX", "ARMCHECKVIEW0"
            lc_Control.Font.Name = "Arial"
            lc_Control.Font.Charset = ll_Charset
        Case "A_SEEK", "A_SRCHTXT"
            lc_Control.Charset = ll_Charset
        End Select
    Next
    
    Exit Sub

errhandler:
    Call ErrorHandler(Me.Name & ".ChangeCharset")
End Sub



Private Function OpenSQLSafe(ByVal ao_Db As ARMSYSCOMLib.ArmDb, ByVal as_Request As String, Optional ByVal al_RowExpectedCount = -1) As Long
On Error GoTo errhandler
    Dim lc_Data As Long
tryAgain:
    lc_Data = ao_Db.OpenSQL(as_Request)
    If lc_Data = 0 Then
        
        Dim ls_ErrMsg As String
        ls_ErrMsg = "SQL Error: " & GetDbError(ao_Db)
        
        If ReconnectSafe() Then
            GoTo tryAgain
        End If
        
        Call Err.Raise(1, "ao_Db.OpenSQL - " & "SQL : " & as_Request, ls_ErrMsg)
    End If
    
    If al_RowExpectedCount <> -1 Then
        ' Then check the rowcount
        If ao_Db.RowCount(lc_Data) <> al_RowExpectedCount Then
            Call Err.Raise(2, "SQL : " & as_Request, al_RowExpectedCount & "<>" & ao_Db.RowCount(lc_Data))
        End If
    End If
    OpenSQLSafe = lc_Data
    Exit Function
errhandler:
    Call ErrorHandler(Me.Name & ".OpenSQLSafe")
End Function

Private Sub ExecuteSQLSafe(ByVal ao_Db As ARMSYSCOMLib.ArmDb, ByVal as_Request As String, Optional ByVal al_RowAffectedCount = -1, Optional ab_DuplicityCheck As Boolean = False)
On Error GoTo errhandler

tryAgain:
    ' First execute the request
    If Not ao_Db.ExecuteSQL(as_Request) Then
        If GetArrayValue(ao_Db.SQLErrorCodes, 0) = 547 Then
            Err.Raise 3, "SQL : " & as_Request, Join(ao_Db.SQLErrorCodes, SEP2) & SEP1 & Join(ao_Db.SQLErrorMessages, SEP2)
        End If
        
        Dim ls_ErrMsg As String
        ls_ErrMsg = Join(ao_Db.SQLErrorCodes, SEP2) & SEP1 & Join(ao_Db.SQLErrorMessages, SEP2)
        
        If ReconnectSafe() Then
            GoTo tryAgain
        End If
        
        Err.Raise 1, "SQL : " & as_Request, ls_ErrMsg
    End If

    If al_RowAffectedCount <> -1 Then
        ' Then check the rowcount
        If ao_Db.SQLRowsAffected <> al_RowAffectedCount Then
            
            If ab_DuplicityCheck Then
                Err.Raise 4, "SQL : " & as_Request, al_RowAffectedCount & "<>" & ao_Db.SQLRowsAffected
            Else
                Err.Raise 5, "SQL : " & as_Request, al_RowAffectedCount & "<>" & ao_Db.SQLRowsAffected
            End If
        End If
    End If
    
    Exit Sub

errhandler:
    Call ErrorHandler(Me.Name & ".ExecuteSQLSafe")
End Sub

Private Function ReconnectSafe() As Boolean
On Error GoTo errhandler

    ReconnectSafe = False
    
    Dim ll_Counter As Long
    ll_Counter = 3              ' try 3 times to connect
    
    If IsLostConnection(mo_Db) Then
    
        Call mo_Db.Disconnect
        
        Do While ll_Counter > 0
        
            If mo_Db.Connect(ms_reconnectServer, ms_reconnectDB, ms_reconnectUser, ms_reconnectPassword, ms_reconnectApp) Then
                ReconnectSafe = True
                Exit Do
            End If
            
            ll_Counter = ll_Counter - 1
        Loop
        
    End If
    
    Exit Function
errhandler:
     Call ErrorHandler("ReconnectSafe()")
End Function

Private Function IsLostConnection(ByRef ao_Armdb As ArmDb) As Boolean
On Error GoTo errhandler
    
    IsLostConnection = Not ao_Armdb.IsConnected
    
    If IsArray(ao_Armdb.SQLErrorCodes) Then
        Dim lv_ErrCode As Variant
        Dim ll_Index As Long
        
        lv_ErrCode = ao_Armdb.SQLErrorCodes
        
        For ll_Index = LBound(lv_ErrCode) To UBound(lv_ErrCode)
            If lv_ErrCode(ll_Index) = 11 Then       '[DBNETLIB][ConnectionWrite (send()).]General network error. Check your network documentation.
                IsLostConnection = True
                Exit For
            End If
        Next

    End If
    
    Exit Function
errhandler:
     Call ErrorHandler("IsLostConnection()")
End Function

Private Function GetArrayValue(ByRef ao_variantArray As Variant, ByVal al_Index As Long) As Variant
    If IsArray(ao_variantArray) Then
        If UBound(ao_variantArray) <= al_Index Then
            GetArrayValue = ao_variantArray(al_Index)
        Else
            GetArrayValue = 0
        End If
    Else
        GetArrayValue = 0
    End If
End Function

Public Sub Run(ByVal as_DCS_Code As String, ByVal al_DCS_LinkedTrans As Long, ByVal as_action As String)
On Error GoTo errhandler

    DCS_LinkedTrans = al_DCS_LinkedTrans
    Result = False
    
    Select Case as_action
        Case "A"
            Debug.Assert (as_DCS_Code = "")
            Call Item_InitAdd
        Case "U"
            Debug.Assert (as_DCS_Code <> "")
            Call Item_InitUpdate(as_DCS_Code)
        Case "D"
            Debug.Assert (as_DCS_Code <> "")
            Call Item_InitDelete(as_DCS_Code)
            ' delete is without check so we setup default result as true
            Result = True
        Case "V"
            Debug.Assert (as_DCS_Code <> "")
            Call Item_InitView(as_DCS_Code)
    End Select
        
    Dim ll_oldCursor As Long
    ll_oldCursor = Screen.MousePointer
    Screen.MousePointer = vbDefault
    Call Me.show(vbModal)
    Screen.MousePointer = ll_oldCursor

    Exit Sub
errhandler:
    Call ErrorHandler(Name & ".Run")
End Sub

Private Sub EnableControl(ByVal ao_Control As Control, ByVal ab_Enabled As Boolean)
On Error GoTo errhandler

    Select Case UCase(TypeName(ao_Control))
        Case "FRAME", "LABEL", "MSFLEXGRID", "SHAPE", "ARMGRID", "ARMCHECKVIEW", "TABSTRIP"
            ao_Control.Enabled = ab_Enabled
            ' Do nothing !
        Case "LISTVIEW"
            ' Do nothing !
        Case "TEXTBOX"
            ao_Control.Locked = Not ab_Enabled
            ao_Control.BackColor = IIf(ab_Enabled, CL_COLOR_ENABLED, CL_COLOR_DISABLED)
            ao_Control.TabStop = ab_Enabled
        Case "OPTIONBUTTON"
            ao_Control.Enabled = ab_Enabled
        Case "ARMCOMBOBOX", "A_CALOCX", "OPTIONBUTTON", "ARMTREEVIEW", "LISTBOX", "PICTUREBOX", "CHECKBOX", "COMMANDBUTTON", "TOOLBARCONTROL"
            ao_Control.Enabled = ab_Enabled
            ao_Control.TabStop = ab_Enabled
        Case Else
          Debug.Print ao_Control.Name
    End Select
  Exit Sub
errhandler:
  Call ErrorHandler("EnableControl")
End Sub
Private Function SQLNum(ByVal as_str As String) As String
    SQLNum = Replace(as_str, ",", ".")
End Function

